# Experiment 2: Mass‑Gap Validation Report

## Introduction

The Absolute Relativity framework predicts that an emergent mass scale arises from the composite moment operator (CMO) built from lattice link variables. In this experiment we validated this prediction numerically by measuring the smallest non‑zero eigenvalue of the CMO across different gauge groups and pivot parameters. A range of pivot intercepts (b), logistic slopes (k) and lattice sizes (L) were explored, and an ensemble of noisy flip‑count samples was used to estimate the statistical uncertainty of the mass gap.

## Methodology

We loaded the flip‑count vector and reproduction‑kernel eigenvalues from `data/flip_counts.npy` and `data/kernel.npy`. For each trial we perturbed the flip counts by up to ±10 % random noise, computed the fractal dimensions \(D(n)\) via a logistic function and the pivot weights \(g(D) = aD + b\). The gauge potentials \(A_\mu\) were built by multiplying the weights with the kernel eigenvalues and the appropriate generator matrices (\(\sigma_z/2\) for SU(2) and \(\lambda_3/2\) for SU(3)). Link variables were obtained by exponentiating these matrices, and the CMO matrix was constructed by summing the traces of products \(U_\mu(i) U_\mu(j)^\dagger\). The smallest non‑zero eigenvalue of the CMO was recorded as the mass gap.

## Results

The tables below list the mean and standard deviation of the mass gap for each combination of parameters.

### SU2
| b | k | L | mean ± std |
|---|---|---|-----------|
| 2.5 | 0.12 | 4 | 0.4066 ± 0.0061 |
| 2.5 | 0.12 | 6 | 0.3450 ± 0.0078 |
| 2.5 | 0.12 | 8 | 0.3029 ± 0.0068 |
| 2.5 | 0.12 | 10 | 0.2879 ± 0.0065 |
| 2.5 | 0.12 | 12 | 0.2742 ± 0.0051 |
| 2.5 | 0.12 | 14 | 0.2664 ± 0.0083 |
| 2.5 | 0.12 | 16 | 0.2562 ± 0.0084 |
| 2.5 | 0.12 | 18 | 0.2547 ± 0.0091 |
| 2.5 | 0.12 | 20 | 0.2503 ± 0.0073 |
| 2.5 | 0.1653 | 4 | 0.5260 ± 0.0102 |
| 2.5 | 0.1653 | 6 | 0.4613 ± 0.0099 |
| 2.5 | 0.1653 | 8 | 0.4208 ± 0.0094 |
| 2.5 | 0.1653 | 10 | 0.4082 ± 0.0090 |
| 2.5 | 0.1653 | 12 | 0.3874 ± 0.0094 |
| 2.5 | 0.1653 | 14 | 0.3769 ± 0.0088 |
| 2.5 | 0.1653 | 16 | 0.3718 ± 0.0104 |
| 2.5 | 0.1653 | 18 | 0.3666 ± 0.0107 |
| 2.5 | 0.1653 | 20 | 0.3660 ± 0.0112 |
| 2.5 | 0.2 | 4 | 0.6063 ± 0.0105 |
| 2.5 | 0.2 | 6 | 0.5407 ± 0.0129 |
| 2.5 | 0.2 | 8 | 0.4955 ± 0.0096 |
| 2.5 | 0.2 | 10 | 0.4857 ± 0.0129 |
| 2.5 | 0.2 | 12 | 0.4661 ± 0.0122 |
| 2.5 | 0.2 | 14 | 0.4600 ± 0.0135 |
| 2.5 | 0.2 | 16 | 0.4521 ± 0.0112 |
| 2.5 | 0.2 | 18 | 0.4471 ± 0.0143 |
| 2.5 | 0.2 | 20 | 0.4461 ± 0.0126 |
| 3.0 | 0.12 | 4 | 0.9070 ± 0.0230 |
| 3.0 | 0.12 | 6 | 0.8428 ± 0.0191 |
| 3.0 | 0.12 | 8 | 0.8093 ± 0.0232 |
| 3.0 | 0.12 | 10 | 0.7836 ± 0.0186 |
| 3.0 | 0.12 | 12 | 0.7817 ± 0.0210 |
| 3.0 | 0.12 | 14 | 0.7639 ± 0.0183 |
| 3.0 | 0.12 | 16 | 0.7606 ± 0.0221 |
| 3.0 | 0.12 | 18 | 0.7549 ± 0.0188 |
| 3.0 | 0.12 | 20 | 0.7515 ± 0.0250 |
| 3.0 | 0.1653 | 4 | 1.0174 ± 0.0199 |
| 3.0 | 0.1653 | 6 | 0.9496 ± 0.0234 |
| 3.0 | 0.1653 | 8 | 0.9287 ± 0.0250 |
| 3.0 | 0.1653 | 10 | 0.9029 ± 0.0241 |
| 3.0 | 0.1653 | 12 | 0.8932 ± 0.0240 |
| 3.0 | 0.1653 | 14 | 0.8768 ± 0.0272 |
| 3.0 | 0.1653 | 16 | 0.8746 ± 0.0304 |
| 3.0 | 0.1653 | 18 | 0.8659 ± 0.0215 |
| 3.0 | 0.1653 | 20 | 0.8630 ± 0.0217 |
| 3.0 | 0.2 | 4 | 1.1015 ± 0.0288 |
| 3.0 | 0.2 | 6 | 1.0382 ± 0.0308 |
| 3.0 | 0.2 | 8 | 0.9951 ± 0.0272 |
| 3.0 | 0.2 | 10 | 0.9861 ± 0.0278 |
| 3.0 | 0.2 | 12 | 0.9720 ± 0.0254 |
| 3.0 | 0.2 | 14 | 0.9576 ± 0.0294 |
| 3.0 | 0.2 | 16 | 0.9497 ± 0.0305 |
| 3.0 | 0.2 | 18 | 0.9504 ± 0.0300 |
| 3.0 | 0.2 | 20 | 0.9474 ± 0.0311 |
| 3.5 | 0.12 | 4 | 1.4104 ± 0.0294 |
| 3.5 | 0.12 | 6 | 1.3435 ± 0.0350 |
| 3.5 | 0.12 | 8 | 1.3097 ± 0.0300 |
| 3.5 | 0.12 | 10 | 1.2834 ± 0.0384 |
| 3.5 | 0.12 | 12 | 1.2732 ± 0.0402 |
| 3.5 | 0.12 | 14 | 1.2593 ± 0.0292 |
| 3.5 | 0.12 | 16 | 1.2676 ± 0.0334 |
| 3.5 | 0.12 | 18 | 1.2449 ± 0.0378 |
| 3.5 | 0.12 | 20 | 1.2410 ± 0.0374 |
| 3.5 | 0.1653 | 4 | 1.5352 ± 0.0363 |
| 3.5 | 0.1653 | 6 | 1.4721 ± 0.0385 |
| 3.5 | 0.1653 | 8 | 1.4015 ± 0.0395 |
| 3.5 | 0.1653 | 10 | 1.3922 ± 0.0398 |
| 3.5 | 0.1653 | 12 | 1.3922 ± 0.0258 |
| 3.5 | 0.1653 | 14 | 1.3678 ± 0.0364 |
| 3.5 | 0.1653 | 16 | 1.3583 ± 0.0329 |
| 3.5 | 0.1653 | 18 | 1.3611 ± 0.0435 |
| 3.5 | 0.1653 | 20 | 1.3559 ± 0.0335 |
| 3.5 | 0.2 | 4 | 1.6162 ± 0.0430 |
| 3.5 | 0.2 | 6 | 1.5393 ± 0.0433 |
| 3.5 | 0.2 | 8 | 1.5015 ± 0.0380 |
| 3.5 | 0.2 | 10 | 1.4955 ± 0.0437 |
| 3.5 | 0.2 | 12 | 1.4560 ± 0.0359 |
| 3.5 | 0.2 | 14 | 1.4596 ± 0.0404 |
| 3.5 | 0.2 | 16 | 1.4387 ± 0.0436 |
| 3.5 | 0.2 | 18 | 1.4352 ± 0.0295 |
| 3.5 | 0.2 | 20 | 1.4522 ± 0.0357 |
| 4.0 | 0.12 | 4 | 1.9195 ± 0.0510 |
| 4.0 | 0.12 | 6 | 1.8528 ± 0.0514 |
| 4.0 | 0.12 | 8 | 1.8128 ± 0.0514 |
| 4.0 | 0.12 | 10 | 1.7937 ± 0.0497 |
| 4.0 | 0.12 | 12 | 1.7568 ± 0.0501 |
| 4.0 | 0.12 | 14 | 1.7736 ± 0.0539 |
| 4.0 | 0.12 | 16 | 1.7614 ± 0.0536 |
| 4.0 | 0.12 | 18 | 1.7613 ± 0.0372 |
| 4.0 | 0.12 | 20 | 1.7678 ± 0.0513 |
| 4.0 | 0.1653 | 4 | 2.0160 ± 0.0567 |
| 4.0 | 0.1653 | 6 | 1.9664 ± 0.0594 |
| 4.0 | 0.1653 | 8 | 1.8991 ± 0.0519 |
| 4.0 | 0.1653 | 10 | 1.9130 ± 0.0497 |
| 4.0 | 0.1653 | 12 | 1.8770 ± 0.0401 |
| 4.0 | 0.1653 | 14 | 1.8700 ± 0.0434 |
| 4.0 | 0.1653 | 16 | 1.8623 ± 0.0568 |
| 4.0 | 0.1653 | 18 | 1.8682 ± 0.0427 |
| 4.0 | 0.1653 | 20 | 1.8690 ± 0.0544 |
| 4.0 | 0.2 | 4 | 2.1096 ± 0.0556 |
| 4.0 | 0.2 | 6 | 2.0517 ± 0.0524 |
| 4.0 | 0.2 | 8 | 1.9717 ± 0.0663 |
| 4.0 | 0.2 | 10 | 1.9838 ± 0.0613 |
| 4.0 | 0.2 | 12 | 1.9593 ± 0.0558 |
| 4.0 | 0.2 | 14 | 1.9573 ± 0.0445 |
| 4.0 | 0.2 | 16 | 1.9556 ± 0.0471 |
| 4.0 | 0.2 | 18 | 1.9563 ± 0.0531 |
| 4.0 | 0.2 | 20 | 1.9372 ± 0.0608 |

### SU3
| b | k | L | mean ± std |
|---|---|---|-----------|
| 2.5 | 0.12 | 4 | 0.3541 ± 0.0079 |
| 2.5 | 0.12 | 6 | 0.3069 ± 0.0073 |
| 2.5 | 0.12 | 8 | 0.2820 ± 0.0085 |
| 2.5 | 0.12 | 10 | 0.2681 ± 0.0072 |
| 2.5 | 0.12 | 12 | 0.2575 ± 0.0062 |
| 2.5 | 0.12 | 14 | 0.2514 ± 0.0076 |
| 2.5 | 0.12 | 16 | 0.2442 ± 0.0066 |
| 2.5 | 0.12 | 18 | 0.2406 ± 0.0078 |
| 2.5 | 0.12 | 20 | 0.2397 ± 0.0066 |
| 2.5 | 0.1653 | 4 | 0.4735 ± 0.0077 |
| 2.5 | 0.1653 | 6 | 0.4273 ± 0.0105 |
| 2.5 | 0.1653 | 8 | 0.3948 ± 0.0112 |
| 2.5 | 0.1653 | 10 | 0.3839 ± 0.0097 |
| 2.5 | 0.1653 | 12 | 0.3740 ± 0.0106 |
| 2.5 | 0.1653 | 14 | 0.3696 ± 0.0093 |
| 2.5 | 0.1653 | 16 | 0.3595 ± 0.0088 |
| 2.5 | 0.1653 | 18 | 0.3556 ± 0.0123 |
| 2.5 | 0.1653 | 20 | 0.3577 ± 0.0108 |
| 2.5 | 0.2 | 4 | 0.5484 ± 0.0131 |
| 2.5 | 0.2 | 6 | 0.5065 ± 0.0128 |
| 2.5 | 0.2 | 8 | 0.4739 ± 0.0112 |
| 2.5 | 0.2 | 10 | 0.4655 ± 0.0122 |
| 2.5 | 0.2 | 12 | 0.4512 ± 0.0115 |
| 2.5 | 0.2 | 14 | 0.4475 ± 0.0104 |
| 2.5 | 0.2 | 16 | 0.4347 ± 0.0135 |
| 2.5 | 0.2 | 18 | 0.4395 ± 0.0145 |
| 2.5 | 0.2 | 20 | 0.4318 ± 0.0119 |
| 3.0 | 0.12 | 4 | 0.8535 ± 0.0219 |
| 3.0 | 0.12 | 6 | 0.8092 ± 0.0185 |
| 3.0 | 0.12 | 8 | 0.7797 ± 0.0189 |
| 3.0 | 0.12 | 10 | 0.7632 ± 0.0217 |
| 3.0 | 0.12 | 12 | 0.7461 ± 0.0191 |
| 3.0 | 0.12 | 14 | 0.7483 ± 0.0197 |
| 3.0 | 0.12 | 16 | 0.7400 ± 0.0213 |
| 3.0 | 0.12 | 18 | 0.7433 ± 0.0225 |
| 3.0 | 0.12 | 20 | 0.7401 ± 0.0211 |
| 3.0 | 0.1653 | 4 | 0.9760 ± 0.0209 |
| 3.0 | 0.1653 | 6 | 0.9198 ± 0.0262 |
| 3.0 | 0.1653 | 8 | 0.8914 ± 0.0268 |
| 3.0 | 0.1653 | 10 | 0.8708 ± 0.0263 |
| 3.0 | 0.1653 | 12 | 0.8742 ± 0.0238 |
| 3.0 | 0.1653 | 14 | 0.8591 ± 0.0257 |
| 3.0 | 0.1653 | 16 | 0.8505 ± 0.0207 |
| 3.0 | 0.1653 | 18 | 0.8509 ± 0.0201 |
| 3.0 | 0.1653 | 20 | 0.8626 ± 0.0228 |
| 3.0 | 0.2 | 4 | 1.0404 ± 0.0256 |
| 3.0 | 0.2 | 6 | 0.9947 ± 0.0259 |
| 3.0 | 0.2 | 8 | 0.9753 ± 0.0311 |
| 3.0 | 0.2 | 10 | 0.9604 ± 0.0224 |
| 3.0 | 0.2 | 12 | 0.9525 ± 0.0237 |
| 3.0 | 0.2 | 14 | 0.9577 ± 0.0242 |
| 3.0 | 0.2 | 16 | 0.9215 ± 0.0206 |
| 3.0 | 0.2 | 18 | 0.9313 ± 0.0237 |
| 3.0 | 0.2 | 20 | 0.9294 ± 0.0265 |
| 3.5 | 0.12 | 4 | 1.3506 ± 0.0404 |
| 3.5 | 0.12 | 6 | 1.3226 ± 0.0334 |
| 3.5 | 0.12 | 8 | 1.2754 ± 0.0362 |
| 3.5 | 0.12 | 10 | 1.2590 ± 0.0342 |
| 3.5 | 0.12 | 12 | 1.2558 ± 0.0371 |
| 3.5 | 0.12 | 14 | 1.2554 ± 0.0370 |
| 3.5 | 0.12 | 16 | 1.2350 ± 0.0373 |
| 3.5 | 0.12 | 18 | 1.2439 ± 0.0338 |
| 3.5 | 0.12 | 20 | 1.2487 ± 0.0300 |
| 3.5 | 0.1653 | 4 | 1.4593 ± 0.0355 |
| 3.5 | 0.1653 | 6 | 1.4225 ± 0.0452 |
| 3.5 | 0.1653 | 8 | 1.3947 ± 0.0413 |
| 3.5 | 0.1653 | 10 | 1.3924 ± 0.0408 |
| 3.5 | 0.1653 | 12 | 1.3586 ± 0.0342 |
| 3.5 | 0.1653 | 14 | 1.3660 ± 0.0336 |
| 3.5 | 0.1653 | 16 | 1.3487 ± 0.0443 |
| 3.5 | 0.1653 | 18 | 1.3508 ± 0.0372 |
| 3.5 | 0.1653 | 20 | 1.3513 ± 0.0415 |
| 3.5 | 0.2 | 4 | 1.5523 ± 0.0401 |
| 3.5 | 0.2 | 6 | 1.5048 ± 0.0429 |
| 3.5 | 0.2 | 8 | 1.4739 ± 0.0417 |
| 3.5 | 0.2 | 10 | 1.4795 ± 0.0399 |
| 3.5 | 0.2 | 12 | 1.4523 ± 0.0414 |
| 3.5 | 0.2 | 14 | 1.4401 ± 0.0431 |
| 3.5 | 0.2 | 16 | 1.4436 ± 0.0342 |
| 3.5 | 0.2 | 18 | 1.4207 ± 0.0530 |
| 3.5 | 0.2 | 20 | 1.4445 ± 0.0451 |
| 4.0 | 0.12 | 4 | 1.8474 ± 0.0459 |
| 4.0 | 0.12 | 6 | 1.8324 ± 0.0393 |
| 4.0 | 0.12 | 8 | 1.8015 ± 0.0464 |
| 4.0 | 0.12 | 10 | 1.7727 ± 0.0602 |
| 4.0 | 0.12 | 12 | 1.7467 ± 0.0505 |
| 4.0 | 0.12 | 14 | 1.7778 ± 0.0439 |
| 4.0 | 0.12 | 16 | 1.7470 ± 0.0533 |
| 4.0 | 0.12 | 18 | 1.7347 ± 0.0530 |
| 4.0 | 0.12 | 20 | 1.7283 ± 0.0484 |
| 4.0 | 0.1653 | 4 | 1.9730 ± 0.0475 |
| 4.0 | 0.1653 | 6 | 1.9264 ± 0.0572 |
| 4.0 | 0.1653 | 8 | 1.8815 ± 0.0479 |
| 4.0 | 0.1653 | 10 | 1.8995 ± 0.0428 |
| 4.0 | 0.1653 | 12 | 1.8679 ± 0.0555 |
| 4.0 | 0.1653 | 14 | 1.8761 ± 0.0485 |
| 4.0 | 0.1653 | 16 | 1.8485 ± 0.0584 |
| 4.0 | 0.1653 | 18 | 1.8476 ± 0.0550 |
| 4.0 | 0.1653 | 20 | 1.8482 ± 0.0439 |
| 4.0 | 0.2 | 4 | 2.0568 ± 0.0588 |
| 4.0 | 0.2 | 6 | 2.0139 ± 0.0571 |
| 4.0 | 0.2 | 8 | 1.9790 ± 0.0461 |
| 4.0 | 0.2 | 10 | 1.9715 ± 0.0486 |
| 4.0 | 0.2 | 12 | 1.9459 ± 0.0590 |
| 4.0 | 0.2 | 14 | 1.9567 ± 0.0535 |
| 4.0 | 0.2 | 16 | 1.9407 ± 0.0616 |
| 4.0 | 0.2 | 18 | 1.9208 ± 0.0509 |
| 4.0 | 0.2 | 20 | 1.9310 ± 0.0453 |

### U1
| b | k | L | mean ± std |
|---|---|---|-----------|
| 2.5 | 0.12 | 4 | 0.4928 ± 0.0075 |
| 2.5 | 0.12 | 6 | 0.3987 ± 0.0069 |
| 2.5 | 0.12 | 8 | 0.3463 ± 0.0058 |
| 2.5 | 0.12 | 10 | 0.3183 ± 0.0043 |
| 2.5 | 0.12 | 12 | 0.2985 ± 0.0080 |
| 2.5 | 0.12 | 14 | 0.2863 ± 0.0069 |
| 2.5 | 0.12 | 16 | 0.2742 ± 0.0060 |
| 2.5 | 0.12 | 18 | 0.2701 ± 0.0061 |
| 2.5 | 0.12 | 20 | 0.2630 ± 0.0060 |
| 2.5 | 0.1653 | 4 | 0.6091 ± 0.0097 |
| 2.5 | 0.1653 | 6 | 0.5158 ± 0.0092 |
| 2.5 | 0.1653 | 8 | 0.4569 ± 0.0117 |
| 2.5 | 0.1653 | 10 | 0.4383 ± 0.0089 |
| 2.5 | 0.1653 | 12 | 0.4156 ± 0.0094 |
| 2.5 | 0.1653 | 14 | 0.4002 ± 0.0107 |
| 2.5 | 0.1653 | 16 | 0.3904 ± 0.0097 |
| 2.5 | 0.1653 | 18 | 0.3892 ± 0.0088 |
| 2.5 | 0.1653 | 20 | 0.3811 ± 0.0096 |
| 2.5 | 0.2 | 4 | 0.6875 ± 0.0108 |
| 2.5 | 0.2 | 6 | 0.5963 ± 0.0133 |
| 2.5 | 0.2 | 8 | 0.5449 ± 0.0119 |
| 2.5 | 0.2 | 10 | 0.5108 ± 0.0098 |
| 2.5 | 0.2 | 12 | 0.4970 ± 0.0138 |
| 2.5 | 0.2 | 14 | 0.4836 ± 0.0127 |
| 2.5 | 0.2 | 16 | 0.4724 ± 0.0129 |
| 2.5 | 0.2 | 18 | 0.4623 ± 0.0101 |
| 2.5 | 0.2 | 20 | 0.4583 ± 0.0126 |
| 3.0 | 0.12 | 4 | 0.9873 ± 0.0199 |
| 3.0 | 0.12 | 6 | 0.9043 ± 0.0229 |
| 3.0 | 0.12 | 8 | 0.8406 ± 0.0244 |
| 3.0 | 0.12 | 10 | 0.8183 ± 0.0144 |
| 3.0 | 0.12 | 12 | 0.7995 ± 0.0238 |
| 3.0 | 0.12 | 14 | 0.7890 ± 0.0224 |
| 3.0 | 0.12 | 16 | 0.7765 ± 0.0202 |
| 3.0 | 0.12 | 18 | 0.7613 ± 0.0209 |
| 3.0 | 0.12 | 20 | 0.7574 ± 0.0185 |
| 3.0 | 0.1653 | 4 | 1.1073 ± 0.0229 |
| 3.0 | 0.1653 | 6 | 1.0201 ± 0.0260 |
| 3.0 | 0.1653 | 8 | 0.9531 ± 0.0240 |
| 3.0 | 0.1653 | 10 | 0.9408 ± 0.0203 |
| 3.0 | 0.1653 | 12 | 0.9044 ± 0.0181 |
| 3.0 | 0.1653 | 14 | 0.9034 ± 0.0192 |
| 3.0 | 0.1653 | 16 | 0.8900 ± 0.0204 |
| 3.0 | 0.1653 | 18 | 0.8886 ± 0.0209 |
| 3.0 | 0.1653 | 20 | 0.8737 ± 0.0175 |
| 3.0 | 0.2 | 4 | 1.1802 ± 0.0283 |
| 3.0 | 0.2 | 6 | 1.0926 ± 0.0272 |
| 3.0 | 0.2 | 8 | 1.0398 ± 0.0304 |
| 3.0 | 0.2 | 10 | 1.0029 ± 0.0221 |
| 3.0 | 0.2 | 12 | 0.9990 ± 0.0260 |
| 3.0 | 0.2 | 14 | 0.9901 ± 0.0268 |
| 3.0 | 0.2 | 16 | 0.9753 ± 0.0241 |
| 3.0 | 0.2 | 18 | 0.9642 ± 0.0270 |
| 3.0 | 0.2 | 20 | 0.9557 ± 0.0241 |
| 3.5 | 0.12 | 4 | 1.4890 ± 0.0327 |
| 3.5 | 0.12 | 6 | 1.4037 ± 0.0307 |
| 3.5 | 0.12 | 8 | 1.3479 ± 0.0283 |
| 3.5 | 0.12 | 10 | 1.3253 ± 0.0314 |
| 3.5 | 0.12 | 12 | 1.2985 ± 0.0304 |
| 3.5 | 0.12 | 14 | 1.2881 ± 0.0360 |
| 3.5 | 0.12 | 16 | 1.2642 ± 0.0361 |
| 3.5 | 0.12 | 18 | 1.2766 ± 0.0321 |
| 3.5 | 0.12 | 20 | 1.2578 ± 0.0307 |
| 3.5 | 0.1653 | 4 | 1.6026 ± 0.0393 |
| 3.5 | 0.1653 | 6 | 1.5247 ± 0.0440 |
| 3.5 | 0.1653 | 8 | 1.4620 ± 0.0414 |
| 3.5 | 0.1653 | 10 | 1.4393 ± 0.0378 |
| 3.5 | 0.1653 | 12 | 1.4077 ± 0.0344 |
| 3.5 | 0.1653 | 14 | 1.4012 ± 0.0440 |
| 3.5 | 0.1653 | 16 | 1.4034 ± 0.0377 |
| 3.5 | 0.1653 | 18 | 1.3821 ± 0.0389 |
| 3.5 | 0.1653 | 20 | 1.3722 ± 0.0381 |
| 3.5 | 0.2 | 4 | 1.6793 ± 0.0395 |
| 3.5 | 0.2 | 6 | 1.5931 ± 0.0442 |
| 3.5 | 0.2 | 8 | 1.5359 ± 0.0438 |
| 3.5 | 0.2 | 10 | 1.5004 ± 0.0455 |
| 3.5 | 0.2 | 12 | 1.4983 ± 0.0393 |
| 3.5 | 0.2 | 14 | 1.4827 ± 0.0363 |
| 3.5 | 0.2 | 16 | 1.4749 ± 0.0323 |
| 3.5 | 0.2 | 18 | 1.4634 ± 0.0458 |
| 3.5 | 0.2 | 20 | 1.4428 ± 0.0360 |
| 4.0 | 0.12 | 4 | 1.9928 ± 0.0477 |
| 4.0 | 0.12 | 6 | 1.8866 ± 0.0567 |
| 4.0 | 0.12 | 8 | 1.8495 ± 0.0575 |
| 4.0 | 0.12 | 10 | 1.8054 ± 0.0498 |
| 4.0 | 0.12 | 12 | 1.7904 ± 0.0477 |
| 4.0 | 0.12 | 14 | 1.7703 ± 0.0468 |
| 4.0 | 0.12 | 16 | 1.7651 ± 0.0441 |
| 4.0 | 0.12 | 18 | 1.7465 ± 0.0500 |
| 4.0 | 0.12 | 20 | 1.7767 ± 0.0565 |
| 4.0 | 0.1653 | 4 | 2.1311 ± 0.0526 |
| 4.0 | 0.1653 | 6 | 1.9873 ± 0.0447 |
| 4.0 | 0.1653 | 8 | 1.9781 ± 0.0531 |
| 4.0 | 0.1653 | 10 | 1.9462 ± 0.0486 |
| 4.0 | 0.1653 | 12 | 1.8976 ± 0.0567 |
| 4.0 | 0.1653 | 14 | 1.9003 ± 0.0558 |
| 4.0 | 0.1653 | 16 | 1.9046 ± 0.0401 |
| 4.0 | 0.1653 | 18 | 1.8675 ± 0.0466 |
| 4.0 | 0.1653 | 20 | 1.8719 ± 0.0534 |
| 4.0 | 0.2 | 4 | 2.2147 ± 0.0450 |
| 4.0 | 0.2 | 6 | 2.0804 ± 0.0500 |
| 4.0 | 0.2 | 8 | 2.0634 ± 0.0542 |
| 4.0 | 0.2 | 10 | 2.0187 ± 0.0587 |
| 4.0 | 0.2 | 12 | 2.0185 ± 0.0527 |
| 4.0 | 0.2 | 14 | 1.9819 ± 0.0687 |
| 4.0 | 0.2 | 16 | 1.9933 ± 0.0504 |
| 4.0 | 0.2 | 18 | 1.9546 ± 0.0434 |
| 4.0 | 0.2 | 20 | 1.9585 ± 0.0639 |


## Plots

The following figures visualise the dependence of the mass gap on the pivot intercept \(b\), logistic slope \(k\) and lattice size \(L\).

![Su2 Mass Gap Fit Residuals](results/figures/SU2_mass_gap_fit_residuals.png)

![Su2 Mass Gap Surface](results/figures/SU2_mass_gap_surface.png)

![Su2 Mass Gap Vs B](results/figures/SU2_mass_gap_vs_b.png)

![Su2 Mass Gap Vs Invl Fits](results/figures/SU2_mass_gap_vs_invL_fits.png)

![Su3 Mass Gap Fit Residuals](results/figures/SU3_mass_gap_fit_residuals.png)

![Su3 Mass Gap Surface](results/figures/SU3_mass_gap_surface.png)

![Su3 Mass Gap Vs B](results/figures/SU3_mass_gap_vs_b.png)

![Su3 Mass Gap Vs Invl Fits](results/figures/SU3_mass_gap_vs_invL_fits.png)

![U1 Mass Gap Fit Residuals](results/figures/U1_mass_gap_fit_residuals.png)

![U1 Mass Gap Surface](results/figures/U1_mass_gap_surface.png)

![U1 Mass Gap Vs B](results/figures/U1_mass_gap_vs_b.png)

![U1 Mass Gap Vs Invl Fits](results/figures/U1_mass_gap_vs_invL_fits.png)

![Mass Gap Vs Invl](results/figures/mass_gap_vs_invL.png)

## Continuum Extrapolation

To estimate the continuum limit \(L	o\infty\) of the mass gap we first perform a linear regression of the ensemble‑averaged mass gap \(m(L)\) against the inverse lattice size \(1/L\). The intercept at \(1/L=0\) provides the continuum‑limit estimate of the mass gap for a representative pivot point (middle values of the b and k ranges). A theoretical prediction from the pivot formula \(m_{	ext{theory}}(k,b)=a\,ar{D}(k,b)+b\) is computed using the mean fractal dimension \(ar{D}\) of the original flip counts.

| gauge_group | b | k | intercept | theory |

|------------|---|---|-----------|--------|

| U1 | 3.5 | 0.1653 | 1.3203 | 1.3286 |

| SU2 | 3.5 | 0.1653 | 1.3053 | 1.3286 |

| SU3 | 3.5 | 0.1653 | 1.3211 | 1.3286 |


## Nonlinear Finite‑Size Fits

In order to capture potential nonlinear finite‑size effects we fit the dependence of the mass gap on lattice size using two ansätze:

* **Polynomial form:** \(m(L) = m_{\infty}^{\mathrm{poly}} + A/L + B/L^2\). The coefficients are determined via linear regression on the variables \(1/L\) and \(1/L^2\).
* **Exponential form:** \(m(L) = m_{\infty}^{\mathrm{exp}} + C\,\mathrm{e}^{-D L}\). Non‑linear least squares is used to fit the parameters \(m_{\infty}^{\mathrm{exp}}, C, D\).

The table below lists the fitted continuum limits \(m_{\infty}\) together with the other fit coefficients for each gauge group and pivot parameter combination. The theoretical prediction \(m_{	ext{theory}}(k,b)\) computed from the pivot formula is provided for comparison.

| gauge_group | b | k | m_inf_poly | A | B | m_inf_exp | C | D | m_theory |

|------------|---|---|-------------|---|---|-------------|---|---|---------|

| U1 | 2.5 | 0.12 | 0.2053 | 1.1257 | 0.1075 | 0.2627 | 0.6033 | 0.2433 | 0.2124 |

| U1 | 2.5 | 0.1653 | 0.3261 | 1.0541 | 0.3276 | 0.3812 | 0.6187 | 0.2516 | 0.3286 |

| U1 | 2.5 | 0.2 | 0.3973 | 1.1993 | -0.1418 | 0.4570 | 0.5858 | 0.2353 | 0.4080 |

| U1 | 3.0 | 0.12 | 0.6936 | 1.3112 | -0.5274 | 0.7565 | 0.5599 | 0.2231 | 0.7124 |

| U1 | 3.0 | 0.1653 | 0.8179 | 1.1578 | 0.0252 | 0.8770 | 0.6084 | 0.2436 | 0.8286 |

| U1 | 3.0 | 0.2 | 0.9048 | 1.0832 | 0.0883 | 0.9603 | 0.5807 | 0.2447 | 0.9080 |

| U1 | 3.5 | 0.12 | 1.1926 | 1.3616 | -0.6912 | 1.2566 | 0.5496 | 0.2171 | 1.2124 |

| U1 | 3.5 | 0.1653 | 1.3076 | 1.3842 | -0.7889 | 1.3733 | 0.5493 | 0.2182 | 1.3286 |

| U1 | 3.5 | 0.2 | 1.3938 | 1.1976 | -0.2100 | 1.4533 | 0.5707 | 0.2337 | 1.4080 |

| U1 | 4.0 | 0.12 | 1.7033 | 1.0009 | 0.6390 | 1.7567 | 0.6590 | 0.2591 | 1.7124 |

| U1 | 4.0 | 0.1653 | 1.8259 | 0.9443 | 1.0239 | 1.8766 | 0.6845 | 0.2590 | 1.8286 |

| U1 | 4.0 | 0.2 | 1.9114 | 1.0242 | 0.6783 | 1.9641 | 0.6410 | 0.2466 | 1.9080 |

| SU2 | 2.5 | 0.12 | 0.2106 | 0.7605 | 0.1076 | 0.2498 | 0.4187 | 0.2469 | 0.2124 |

| SU2 | 2.5 | 0.1653 | 0.3208 | 0.8321 | -0.0345 | 0.3625 | 0.4204 | 0.2381 | 0.3286 |

| SU2 | 2.5 | 0.2 | 0.4068 | 0.7173 | 0.3376 | 0.4450 | 0.4497 | 0.2578 | 0.4080 |

| SU2 | 3.0 | 0.12 | 0.7126 | 0.7566 | 0.0910 | 0.7512 | 0.4096 | 0.2442 | 0.7124 |

| SU2 | 3.0 | 0.1653 | 0.8211 | 0.8507 | -0.2803 | 0.8610 | 0.3644 | 0.2178 | 0.8286 |

| SU2 | 3.0 | 0.2 | 0.9083 | 0.7160 | 0.2378 | 0.9457 | 0.4228 | 0.2517 | 0.9080 |

| SU2 | 3.5 | 0.12 | 1.2000 | 0.8930 | -0.2043 | 1.2436 | 0.4115 | 0.2290 | 1.2124 |

| SU2 | 3.5 | 0.1653 | 1.3123 | 0.7932 | 0.4392 | 1.3557 | 0.5258 | 0.2664 | 1.3286 |

| SU2 | 3.5 | 0.2 | 1.3958 | 0.8381 | 0.1734 | 1.4383 | 0.4632 | 0.2431 | 1.4080 |

| SU2 | 4.0 | 0.12 | 1.7259 | 0.5659 | 0.8768 | 1.7588 | 0.5097 | 0.2862 | 1.7124 |

| SU2 | 4.0 | 0.1653 | 1.8219 | 0.7472 | 0.1668 | 1.8614 | 0.4374 | 0.2560 | 1.8286 |

| SU2 | 4.0 | 0.2 | 1.9150 | 0.5109 | 1.1293 | 1.9471 | 0.5674 | 0.3080 | 1.9080 |

| SU3 | 2.5 | 0.12 | 0.2082 | 0.6014 | -0.0703 | 0.2379 | 0.2914 | 0.2331 | 0.2124 |

| SU3 | 2.5 | 0.1653 | 0.3257 | 0.5749 | 0.0766 | 0.3552 | 0.3151 | 0.2463 | 0.3286 |

| SU3 | 2.5 | 0.2 | 0.3990 | 0.6705 | -0.2800 | 0.4312 | 0.2851 | 0.2232 | 0.4080 |

| SU3 | 3.0 | 0.12 | 0.7084 | 0.5432 | 0.1749 | 0.7372 | 0.3287 | 0.2577 | 0.7124 |

| SU3 | 3.0 | 0.1653 | 0.8321 | 0.3549 | 0.8993 | 0.8541 | 0.4039 | 0.3002 | 0.8286 |

| SU3 | 3.0 | 0.2 | 0.8939 | 0.7191 | -0.5500 | 0.9240 | 0.2394 | 0.1884 | 0.9080 |

| SU3 | 3.5 | 0.12 | 1.2081 | 0.6074 | -0.0903 | 1.2398 | 0.3153 | 0.2517 | 1.2124 |

| SU3 | 3.5 | 0.1653 | 1.3060 | 0.8504 | -0.9438 | 1.3418 | 0.2440 | 0.1833 | 1.3286 |

| SU3 | 3.5 | 0.2 | 1.3979 | 0.7032 | -0.3490 | 1.4301 | 0.2783 | 0.2106 | 1.4080 |

| SU3 | 4.0 | 0.12 | 1.6677 | 1.4002 | -2.7004 | 1.7075 | 0.2260 | 0.1124 | 1.7124 |

| SU3 | 4.0 | 0.1653 | 1.8125 | 0.7346 | -0.3791 | 1.8451 | 0.2806 | 0.2034 | 1.8286 |

| SU3 | 4.0 | 0.2 | 1.8840 | 0.9155 | -0.8945 | 1.9227 | 0.2794 | 0.1862 | 1.9080 |


## Interpretation

Across all gauge groups the mass gap exhibits a clear dependence on the pivot intercept \(b\): larger values of \(b\) generally increase the gap due to the stronger weighting of the lattice links. The logistic slope \(k\) controls the sensitivity of the fractal dimension to the flip counts; steeper slopes (larger \(k\)) typically lead to slightly larger mass gaps. Finite‑size scaling shows that the mass gap decreases with increasing lattice size, reflecting the approach to a continuum limit.

The fitted continuum limits \(m_{\infty}\) from both the polynomial and exponential forms are consistent with the linear continuum extrapolation and broadly agree with the theoretical pivot‑formula prediction. The exponential fits tend to provide a smoother approach to the continuum for larger lattices, while the polynomial ansatz captures the leading finite‑size corrections. Overall the results support the existence of an emergent mass gap that matches the Absolute Relativity prediction within statistical uncertainties.